package gov.va.med.domain.model;

import gov.va.med.domain.typecode.AddressTypeCode;
import gov.va.med.domain.typecode.ContactMethodTypeCode;
import gov.va.med.domain.typecode.PasswordQuestionTypeCode;
import gov.va.med.domain.typecode.ProofLevelTypeCode;
import gov.va.med.framework.conversion.converter.TypeCodeConverter;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.annotations.NotFound;

import com.fortify.annotations.FortifyNotPassword;

/**
 * @hibernate.class table="USERS"
 */
public class User extends DomainObject {
	
	private static Logger logger = LogManager.getLogger(User.class);

	/**
	 * persistent field
	 */
	protected String userid;

	/**
	 * nullable persistent field
	 */
	protected String icn;

	/**
	 * persistent field
	 */
	protected String gender;

	/**
	 * persistent field
	 */
	protected String firstName;

	/**
	 * nullable persistent field
	 */
	protected String middleInitial;

	/**
	 * persistent field
	 */
	protected String lastName;

	/**
	 * nullable persistent field
	 */
	protected String suffix;

	/**
	 * persistent field
	 */
	protected String socialSecurityNumber;

	/**
	 * persistent field
	 */
	protected Date dateOfBirth;

	/**
	 * persistent field
	 */
	private ProofLevelTypeCode proofLevel;

	/**
	 * persistent field
	 */
	protected Date proofLevelDate;

	/**
	 * persistent field
	 */
	protected BigDecimal passwordHintQuestion1;

	/**
	 * persistent field
	 */
	protected String passwordHintAnswer1;

	/**
	 * persistent field
	 */
	protected BigDecimal passwordHintQuestion2;

	/**
	 * persistent field
	 */
	protected String passwordHintAnswer2;

	/**
	 * persistent field
	 */
	protected Date passwordLastChanged;

	/**
	 * persistent field
	 */
	protected boolean forgotPasswordLockOut;

	/**
	 * persistent field
	 */
	protected boolean confirmationLockOut;

	/**
	 * persistent field
	 */
	protected Date lastLogin;

	/**
	 * nullable persistent field
	 */
	protected String emailAddress;

	/**
	 * nullable persistent field
	 */
	protected String emailHealthAwarenessInd;

	/**
	 * nullable persistent field
	 */
	protected String emailCredentialsInd;

	/**
	 * nullable persistent field
	 */
	protected String contactMethodPreference;

	/**
	 * nullable persistent field
	 */
	protected String currentOccupation;

	/**
	 * nullable persistent field
	 */
	protected String bloodType;

	/**
	 * nullable persistent field
	 */
	protected String maritalStatus;

	/**
	 * nullable persistent field
	 */
	protected String userAlias;

	/**
	 * persistent field
	 */
	protected String userStatus;

	/**
	 * persistent field
	 */
	protected byte lockCount;

	/**
	 * nullable persistent field
	 */
	protected Date lockDate;

	/**
	 * persistent field
	 */
	@FortifyNotPassword
	protected String temporaryPassword = "N";

	/**
	 * nullable persistent field
	 */
	protected String physicalProofInd;

	/**
	 * nullable persistent field
	 */
	protected String orientationVideoViewInd;

	/**
	 * nullable persistent field
	 */
	protected String participationFormSignInd;

	/**
	 * nullable persistent field
	 */
	protected String ehrAccessInd;

	/**
	 * nullable persistent field
	 */
	protected String mhvId;

	/**
	 * nullable persistent field
	 */
	protected Date autoAuthDate;

	/**
	 * persistent field
	 */
	protected String autoAuthInd = "N";

	/**
	 * persistent field
	 */
	protected Long proofInstitutionId;

	protected Set contactInformationSet;
	protected Set alerts;
	protected ContactInformation contactInformation;
    protected Set addresses;

	/**
	 * @hibernate.property column="USERID"
	 * length="50"
	 * not-null="true"
	 */
	public String getUserid() {
		return this.userid;
	}

	public void setUserid(String userid) {
		this.userid = userid;
	}

	/**
	 * @hibernate.property column="GENDER"
	 * length="1"
	 * not-null="true"
	 */
	public String getGender() {
		return this.gender;
	}

	public void setGender(String gender) {
		this.gender = gender;
	}

	/**
	 * @hibernate.property column="FIRST_NAME"
	 * length="50"
	 * not-null="true"
	 */
	public String getFirstName() {
		return this.firstName;
	}

	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	/**
	 * @hibernate.property column="MIDDLE_INITIAL"
	 * length="1"
	 */
	public String getMiddleInitial() {
		return this.middleInitial;
	}

	public void setMiddleInitial(String middleInitial) {
		this.middleInitial = middleInitial;
	}

	/**
	 * @hibernate.property column="LAST_NAME"
	 * length="50"
	 * not-null="true"
	 */
	public String getLastName() {
		return this.lastName;
	}

	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

	/**
	 * @hibernate.property column="SUFFIX"
	 * length="20"
	 */
	public String getSuffix() {
		return this.suffix;
	}

	public void setSuffix(String suffix) {
		this.suffix = suffix;
	}

	/**
	 * @hibernate.property column="SOCIAL_SECURITY_NUMBER"
	 * length="11"
	 * not-null="true"
	 */
	public String getSocialSecurityNumber() {
		return this.socialSecurityNumber;
	}

	public void setSocialSecurityNumber(String socialSecurityNumber) {
		this.socialSecurityNumber = socialSecurityNumber;
	}

	/**
	 * @hibernate.property column="DATE_OF_BIRTH"
	 * length="7"
	 * not-null="true"
	 */
	public Date getDateOfBirth() {
		return this.dateOfBirth;
	}

	public void setDateOfBirth(Date dateOfBirth) {
		this.dateOfBirth = dateOfBirth;
	}

	/**
	 * @hibernate.property column="PROOF_LEVEL" length="1" not-null="true"
	 */
	public ProofLevelTypeCode getProofLevel() {
		return this.proofLevel;
	}

	public void setProofLevel(ProofLevelTypeCode proofLevelTypeCode) {
		this.proofLevel = proofLevelTypeCode;
	}

	public boolean isHeavyProofed() {
		return this.proofLevel == ProofLevelTypeCode.HEAVY_PROOFED;
	}
	
	public boolean isLightProofed() {
		return this.proofLevel == ProofLevelTypeCode.LIGHT_PROOFED;
	}
	
	public boolean isSubmitted() {
		return this.proofLevel == ProofLevelTypeCode.SUBMITTED;
	}
	
	public boolean isInProcess() {
		return this.proofLevel == ProofLevelTypeCode.IN_PROCESS;
	}

	/**
	 * @hibernate.property column="PROOF_LEVEL_DATE"
	 * length="7"
	 * not-null="true"
	 */
	public Date getProofLevelDate() {
		return this.proofLevelDate;
	}

	public void setProofLevelDate(Date proofLevelDate) {
		this.proofLevelDate = proofLevelDate;
	}

	/**
	 * @hibernate.property column="PASSWORD_HINT_QUESTION_1"
	 * length="22"
	 * not-null="true"
	 */
	public BigDecimal getPasswordHintQuestion1() {
		return this.passwordHintQuestion1;
	}

	public void setPasswordHintQuestion1(BigDecimal passwordHintQuestion1) {
		this.passwordHintQuestion1 = passwordHintQuestion1;
	}

	/**
	 * @hibernate.property column="PASSWORD_HINT_ANSWER_1"
	 * length="35"
	 * not-null="true"
	 */
	public String getPasswordHintAnswer1() {
		return this.passwordHintAnswer1;
	}

	public void setPasswordHintAnswer1(String passwordHintAnswer1) {
		this.passwordHintAnswer1 = passwordHintAnswer1;
	}

	/**
	 * @hibernate.property column="PASSWORD_HINT_QUESTION_2"
	 * length="22"
	 * not-null="true"
	 */
	public BigDecimal getPasswordHintQuestion2() {
		return this.passwordHintQuestion2;
	}

	public void setPasswordHintQuestion2(BigDecimal passwordHintQuestion2) {
		this.passwordHintQuestion2 = passwordHintQuestion2;
	}

	/**
	 * @hibernate.property column="PASSWORD_HINT_ANSWER_2"
	 * length="35"
	 * not-null="true"
	 */
	public String getPasswordHintAnswer2() {
		return this.passwordHintAnswer2;
	}

	public void setPasswordHintAnswer2(String passwordHintAnswer2) {
		this.passwordHintAnswer2 = passwordHintAnswer2;
	}

	/**
	 * @hibernate.property column="PASSWORD_LAST_CHANGED"
	 * length="7"
	 * not-null="true"
	 */
	public Date getPasswordLastChanged() {
		return this.passwordLastChanged;
	}

	public void setPasswordLastChanged(Date passwordLastChanged) {
		this.passwordLastChanged = passwordLastChanged;
	}

	/**
	 * @hibernate.property column="FORGOT_PASSWORD_LOCK_OUT"
	 * length="1"
	 * not-null="true"
	 */
	public boolean isForgotPasswordLockOut() {
		return this.forgotPasswordLockOut;
	}

	public void setForgotPasswordLockOut(boolean forgotPasswordLockOut) {
		this.forgotPasswordLockOut = forgotPasswordLockOut;
	}

	/**
	 * @hibernate.property column="CONFIRMATION_LOCK_OUT"
	 * length="1"
	 * not-null="true"
	 */
	public boolean isConfirmationLockOut() {
		return this.confirmationLockOut;
	}

	public void setConfirmationLockOut(boolean confirmationLockOut) {
		this.confirmationLockOut = confirmationLockOut;
	}

	/**
	 * @hibernate.property column="LAST_LOGIN"
	 * length="7"
	 * not-null="true"
	 */
	public Date getLastLogin() {
		return this.lastLogin;
	}

	public void setLastLogin(Date lastLogin) {
		this.lastLogin = lastLogin;
	}

	/**
	 * @hibernate.property column="EMAIL_ADDRESS"
	 * length="50"
	 */
	public String getEmailAddress() {
		return this.emailAddress;
	}

	public void setEmailAddress(String emailAddress) {
		this.emailAddress = emailAddress;
	}

	/**
	 * @hibernate.property column="EMAIL_HEALTH_AWARENESS_IND"
	 * length="1"
	 */
	public String getEmailHealthAwarenessInd() {
		return this.emailHealthAwarenessInd;
	}

	public void setEmailHealthAwarenessInd(String emailHealthAwarenessInd) {
		this.emailHealthAwarenessInd = emailHealthAwarenessInd;
	}

	/**
	 * @hibernate.property column="EMAIL_CREDENTIALS_IND"
	 * length="1"
	 */
	public String getEmailCredentialsInd() {
		return this.emailCredentialsInd;
	}

	public void setEmailCredentialsInd(String emailCredentialsInd) {
		this.emailCredentialsInd = emailCredentialsInd;
	}

	/**
	 * @hibernate.property column="CONTACT_METHOD_PREFERENCE"
	 * length="2"
	 */
	public String getContactMethodPreference() {
		return this.contactMethodPreference;
	}

	public void setContactMethodPreference(String contactMethodPreference) {
		this.contactMethodPreference = contactMethodPreference;
	}

	/**
	 * @hibernate.property column="CURRENT_OCCUPATION"
	 * length="50"
	 */
	public String getCurrentOccupation() {
		return this.currentOccupation;
	}

	public void setCurrentOccupation(String currentOccupation) {
		this.currentOccupation = currentOccupation;
	}

	/**
	 * @hibernate.property column="BLOOD_TYPE"
	 * length="3"
	 */
	public String getBloodType() {
		return this.bloodType;
	}

	public void setBloodType(String bloodType) {
		this.bloodType = bloodType;
	}

	/**
	 * @hibernate.property column="MARITAL_STATUS"
	 * length="1"
	 */
	public String getMaritalStatus() {
		return this.maritalStatus;
	}

	public void setMaritalStatus(String maritalStatus) {
		this.maritalStatus = maritalStatus;
	}

	/**
	 * @hibernate.property column="USER_ALIAS"
	 * length="50"
	 */
	public String getUserAlias() {
		return this.userAlias;
	}

	public void setUserAlias(String userAlias) {
		this.userAlias = userAlias;
	}

	/**
	 * @hibernate.property column="USER_STATUS"
	 * length="1"
	 * not-null="true"
	 */
	public String getUserStatus() {
		return this.userStatus;
	}

	public void setUserStatus(String userStatus) {
		this.userStatus = userStatus;
	}

	/**
	 * @hibernate.property column="LOCK_COUNT"
	 * length="2"
	 * not-null="true"
	 */
	public byte getLockCount() {
		return this.lockCount;
	}

	public void setLockCount(byte lockCount) {
		this.lockCount = lockCount;
	}

	/**
	 * @hibernate.property column="LOCK_DATE"
	 * length="7"
	 */
	public Date getLockDate() {
		return this.lockDate;
	}

	public void setLockDate(Date lockDate) {
		this.lockDate = lockDate;
	}

	/**
	 * @hibernate.property column="TEMPORARY_PASSWORD"
	 * length="1"
	 * not-null="true"
	 */
	public String getTemporaryPassword() {
		return this.temporaryPassword;
	}

	public void setTemporaryPassword(String temporaryPassword) {
		this.temporaryPassword = temporaryPassword;
	}

	/**
	 * @hibernate.property column="PHYSICAL_PROOF_IND"
	 * length="1"
	 */
	public String getPhysicalProofInd() {
		return this.physicalProofInd;
	}

	public void setPhysicalProofInd(String physicalProofInd) {
		this.physicalProofInd = physicalProofInd;
	}

	/**
	 * @hibernate.property column="ORIENTATION_VIDEO_VIEW_IND"
	 * length="1"
	 */
	public String getOrientationVideoViewInd() {
		return this.orientationVideoViewInd;
	}

	public void setOrientationVideoViewInd(String orientationVideoViewInd) {
		this.orientationVideoViewInd = orientationVideoViewInd;
	}

	/**
	 * @hibernate.property column="PARTICIPATION_FORM_SIGN_IND"
	 * length="1"
	 */
	public String getParticipationFormSignInd() {
		return this.participationFormSignInd;
	}

	public void setParticipationFormSignInd(String participationFormSignInd) {
		this.participationFormSignInd = participationFormSignInd;
	}

	/**
	 * @hibernate.property column="EHR_ACCESS_IND"
	 * length="1"
	 */
	public String getEhrAccessInd() {
		return this.ehrAccessInd;
	}

	public void setEhrAccessInd(String ehrAccessInd) {
		this.ehrAccessInd = ehrAccessInd;
	}

	/**
	 * @hibernate.property column="MHV_ID"
	 * length="10"
	 */
	public String getMhvId() {
		return this.mhvId;
	}

	public void setMhvId(String mhvId) {
		this.mhvId = mhvId;
	}

	/**
	 * @hibernate.property column="AUTO_AUTH_DATE"
	 * length="7"
	 */
	public Date getAutoAuthDate() {
		return this.autoAuthDate;
	}

	public void setAutoAuthDate(Date autoAuthDate) {
		this.autoAuthDate = autoAuthDate;
	}

	/**
	 * @hibernate.property column="AUTO_AUTH_IND"
	 * length="1"
	 * not-null="true"
	 */
	public String getAutoAuthInd() {
		return this.autoAuthInd;
	}

	public void setAutoAuthInd(String autoAuthInd) {
		this.autoAuthInd = autoAuthInd;
	}

	/**
	 * @hibernate.property column="PROOF_INSTITUTION_ID"
	 * length="20"
	 * not-null="false"
	 */
	public Long getProofInstitutionId() {
		return this.proofInstitutionId;
	}

	public void setProofInstitutionId(Long proofInstitutionId) {
		this.proofInstitutionId = proofInstitutionId;
	}

	public ContactInformation getContactInformation() {

		if(contactInformation == null) {
			contactInformation = new ContactInformation();
		}

		ContactInformation current = null;

		if(contactInformationSet == null) {
			contactInformationSet = new HashSet();
		}

		for(Iterator i = contactInformationSet.iterator(); i.hasNext();) {
			current = (ContactInformation)i.next();
			ContactMethodTypeCode contactMethod = current.getContactMethod();

			if(contactMethod.isEmail()) {
				contactInformation.setEmailAddress(current.getEmailAddress());
			}
			else if(contactMethod.isWorkPhone()) {
				contactInformation.setPhoneNumber(current.getPhoneNumber());
				contactInformation.setExtension(current.getExtension());
			}
		}

		return this.contactInformation;
	}

	private void setContactInformation(ContactInformation contactInfo) {

		if(contactInformationSet == null) {
			contactInformationSet = new HashSet();
			contactInformationSet.add(contactInfo);
		}
		else {
			boolean contactFound = false;
			ContactInformation current = null;
			ContactMethodTypeCode contactMethod = contactInfo.getContactMethod();

			for(Iterator i = this.contactInformationSet.iterator(); i.hasNext() && !contactFound;) {
				current = (ContactInformation)i.next();

				ContactMethodTypeCode currentContactMethod = current.getContactMethod();

				if(currentContactMethod.isEmail() && contactMethod.isEmail()) {
					current.setEmailAddress(contactInfo.getEmailAddress());
					contactFound = true;
				}
				else if(currentContactMethod.isWorkPhone() && contactMethod.isWorkPhone()) {
					current.setPhoneNumber(contactInfo.getPhoneNumber());
					current.setExtension(contactInfo.getExtension());
					contactFound = true;
				}
			}

			if(!contactFound) {
				contactInformationSet.add(contactInfo);
			}
		}
	}

	public Set getContactInformationSet() {
		return this.contactInformationSet;
	}

	private void setContactInformationSet(Set info) {
		this.contactInformationSet = info;
	}

	public Set getAlerts() {
		return this.alerts;
	}

	public void setAlerts(Set alerts) {
		this.alerts = alerts;
	}

	public void setPhoneNumber(String phoneNumber) {
		ContactInformation contact = getContactInformation();

		ContactInformation phoneContact = new ContactInformation(ContactMethodTypeCode.WORK_PHONE, phoneNumber, contact.getExtension(),
		                                                         null, null);

		if(this.getId() != null) {
			phoneContact.setUserId((Long)getId());
		}

		this.setContactInformation(phoneContact);
	}

	public void setExtension(String extension) {
		ContactInformation contact = getContactInformation();

		ContactInformation phoneContact = new ContactInformation(ContactMethodTypeCode.WORK_PHONE, contact.getPhoneNumber(), extension,
		                                                         null, null);

		if(this.getId() != null) {
			phoneContact.setUserId((Long)getId());
		}

		this.setContactInformation(phoneContact);
	}

	public void setContactEmail(String email) {
		ContactInformation emailContact = new ContactInformation(ContactMethodTypeCode.EMAIL, null, null,
		                                                         email, null);

		if(this.getId() != null) {
			emailContact.setUserId((Long)getId());
		}

		this.setContactInformation(emailContact);
	}

	public String getName() {
		return this.getFirstName() + " " + this.getLastName();
	}
	
	public String getFormattedSsn() {
		if (socialSecurityNumber != null && socialSecurityNumber.length() == 9) {
			return socialSecurityNumber.substring(0,3) + "-" +
			      socialSecurityNumber.substring(3,5) + "-" +
			      socialSecurityNumber.substring(5,socialSecurityNumber.length());
		}
		return socialSecurityNumber;
	}

	public String getProofLevelDescription() {
		return this.proofLevel.getDescription();
	}

	public String getProofDateString(){
		SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy");
        return formatter.format(this.proofLevelDate);
	}

	/**
     * Upgrades this user to patient by setting the icn
	 * @param icn
	 */
	public void upgradeToPatient(String icn) {
		this.icn = icn;
	}

	public boolean isPrereqsSatisfied() {
		return getIsPhysicalProofed() && getIsOrientationVideoViewed()
		    && getIsParticipationFormSigned() && getIsEhrAccessed();
	}

	public String toString() {
		return new ToStringBuilder(this)
		    .append("id", getId())
		    .append("userid", getUserid())
		    .append("gender", getGender())
		    .append("firstName", getFirstName())
		    .append("middleInitial", getMiddleInitial())
		    .append("lastName", getLastName())
		    .append("suffix", getSuffix())
		    .append("socialSecurityNumber", getSocialSecurityNumber())
		    .append("dateOfBirth", getDateOfBirth())
		    .append("proofLevel", getProofLevel())
		    .append("proofLevelDate", getProofLevelDate())
		    .append("passwordHintQuestion1", getPasswordHintQuestion1())
		    .append("passwordHintAnswer1", getPasswordHintAnswer1())
		    .append("passwordHintQuestion2", getPasswordHintQuestion2())
		    .append("passwordHintAnswer2", getPasswordHintAnswer2())
		    .append("passwordLastChanged", getPasswordLastChanged())
		    .append("forgotPasswordLockOut", isForgotPasswordLockOut())
		    .append("confirmationLockOut", isConfirmationLockOut())
		    .append("lastLogin", getLastLogin())
		    .append("createdDate", getCreatedDate())
		    .append("emailAddress", getEmailAddress())
		    .append("emailHealthAwarenessInd", getEmailHealthAwarenessInd())
		    .append("emailCredentialsInd", getEmailCredentialsInd())
		    .append("contactMethodPreference", getContactMethodPreference())
		    .append("currentOccupation", getCurrentOccupation())
		    .append("bloodType", getBloodType())
		    .append("maritalStatus", getMaritalStatus())
		    .append("userAlias", getUserAlias())
		    .append("userStatus", getUserStatus())
		    .append("lockCount", getLockCount())
		    .append("lockDate", getLockDate())
		    .append("temporaryPassword", getTemporaryPassword())
		    .append("physicalProofInd", getPhysicalProofInd())
		    .append("orientationVideoViewInd", getOrientationVideoViewInd())
		    .append("participationFormSignInd", getParticipationFormSignInd())
		    .append("ehrAccessInd", getEhrAccessInd())
		    .append("autoAuthDate", getAutoAuthDate())
		    .append("autoAuthInd", getAutoAuthInd())
		    .append("proofInstitutionId", getProofInstitutionId())
		    .toString();
	}

	public boolean equals(Object other) {
		if((this == other)) return true;
		if(!(other instanceof User)) return false;
		User castOther = (User)other;
		return new EqualsBuilder()
		    .append(this.getId(), castOther.getId())
		    .append(this.getUserid(), castOther.getUserid())
		    .append(this.getFirstName(), castOther.getFirstName())
		    .append(this.getLastName(), castOther.getLastName())
		    .append(this.getVersionNumber(), castOther.getVersionNumber())
		    .isEquals();
	}

	/**
	 * Compares the key fields used to lookup patient from MPI
	 * and return true if the fields equal, false if not.
	 * This compare is per usages agreement with MPI.
	 * <P>
	 * Treats first name as optional if this User has a null
	 * first name.  This is a variance from the MPI agreement.
	 * It is assumed that the caller using a null first name
	 * has gotten dispensation from MPI.
	 *
	 * @param mpiUser the user as returned from MPI
	 */
	public boolean isSameAsMpiUser(User mpiUser) {

	    if ((getFirstName() != null && mpiUser.getFirstName() == null) || 
	    	mpiUser.getLastName() == null || mpiUser.getSocialSecurityNumber() == null || mpiUser.getDateOfBirth() == null)
	    {
	    	logger.error("User mismatched because of null(s) in key field(s) :\r\nUser = " + this.toString() + "\r\nMpiUser = " + mpiUser);
	    	return false;
	    }
		
		return
		    (getFirstName() == null || getFirstName().equalsIgnoreCase(mpiUser.getFirstName()))
		    &&
		    (getLastName().equalsIgnoreCase(mpiUser.getLastName()))
		    &&
		    (areBirthDatesEqual(getDateOfBirth(), mpiUser.getDateOfBirth()))
		    &&
		    (getSocialSecurityNumber().equalsIgnoreCase(mpiUser.getSocialSecurityNumber()));

	}
	/**
	 * This method compares dates when one can be a TimeStamp that can break the
	 * equals on y/m/d.
	 * @param dateOne
	 * @param dateTwo
	 * @return
	 */
	public boolean areBirthDatesEqual(Date dateOne, Date dateTwo) {

	    GregorianCalendar date1 = new GregorianCalendar();
	    date1.setTime(dateOne);
	    GregorianCalendar date2 = new GregorianCalendar();
	    date2.setTime(dateTwo);

	    return  date1.get(Calendar.DAY_OF_YEAR) == date2.get(Calendar.DAY_OF_YEAR)  &&
	    		date1.get(Calendar.YEAR) == date2.get(Calendar.YEAR);
	}

	public long getLongId() {
		return ((Long)getId()).longValue();
	}

    public boolean getIsPhysicalProofed()
    {
        return (getPhysicalProofInd() != null && getPhysicalProofInd().equals("Y"));
    }

    public boolean getIsOrientationVideoViewed()
    {
        return (getOrientationVideoViewInd() != null && getOrientationVideoViewInd().equals("Y"));
    }

    public boolean getIsParticipationFormSigned()
    {
        return (getParticipationFormSignInd() != null && getParticipationFormSignInd().equals("Y"));
    }

    public boolean getIsEhrAccessed()
    {
        return (getEhrAccessInd() != null && getEhrAccessInd().equals("Y"));
    }

    public String getDateOfBirthString() {
        SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy");
        return formatter.format(dateOfBirth);
    }

    public Set getAddresses() {
        return addresses;
    }

    public void setAddresses(Set addresses) {
        this.addresses = addresses;
    }

    public String getZipCode() {
        if (addresses==null)
            return null;

        String zipCode = "";
        for(Iterator i = addresses.iterator(); i.hasNext();) {
            Address address = (Address)i.next();
            if(address.getAddressType()==AddressTypeCode.MAILING) {
                zipCode = address.getZipCode();
                break;
            }
        }
        return zipCode;
    }

    public String getFullName() {
        StringBuffer fullName = new StringBuffer();
        fullName.append(getFirstName());
        if (getMiddleInitial()!=null && !getMiddleInitial().equals(""))
            fullName.append(" " + getMiddleInitial());
        fullName.append(" " + getLastName());
        if (getSuffix()!=null && !getSuffix().equals(""))
            fullName.append(", " + getSuffix());
        return fullName.toString();
    }

    /**
     * Complete name used for sorting by last name, first name, middle initial, 
     * suffix in ascending alphabetical order
     * @return complete name for sorting
     */
    public String getCompleteName() {
        StringBuffer fullName = new StringBuffer();
        fullName.append(getLastName());
        fullName.append(" " + getFirstName());
        if (getMiddleInitial()!=null && !getMiddleInitial().equals(""))
            fullName.append(" " + getMiddleInitial());
        if (getSuffix()!=null && !getSuffix().equals(""))
            fullName.append(", " + getSuffix());
        return fullName.toString();
    }
    
    public String getPwdHintQ1Desc() {
        TypeCodeConverter converter = new TypeCodeConverter();
        return ((PasswordQuestionTypeCode)converter.convert(PasswordQuestionTypeCode.class, 
                getPasswordHintQuestion1())).getDescription();
    }

    public String getPwdHintQ2Desc() {
        TypeCodeConverter converter = new TypeCodeConverter();
        return ((PasswordQuestionTypeCode)converter.convert(PasswordQuestionTypeCode.class, 
                getPasswordHintQuestion2())).getDescription();
    }
}
